/*
 * Author:	William Chia-Wei Cheng (william@cs.ucla.edu)
 *
 * Copyright (C) 1990, 1991, 1992, William Cheng.
 * 
 * Permission limited to the use, copy, modify, and distribute this software
 * and its documentation for any purpose is hereby granted by the Author without
 * fee, provided that the above copyright notice appear in all copies and
 * that both the copyright notice and this permission notice appear in
 * supporting documentation, and that the name of the Author not be used
 * in advertising or publicity pertaining to distribution of the software
 * without specific, written prior permission.  The Author makes no
 * representations about the suitability of this software for any purpose.
 * It is provided "as is" without express or implied warranty.  All other
 * rights are reserved by the Author.
 *
 * THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO
 * EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF
 * USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
 * OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 */
#ifndef lint
static char RCSid[] =
      "@(#)$Header: /amnt/kona/tangram/u/william/X11/TGIF2/RCS/dialog.c,v 2.40.1.2 1992/10/20 04:19:42 william Exp $";
#endif

#include <stdio.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include "const.h"
#include "types.h"

#include "auxtext.e"
#include "box.e"
#include "cursor.e"
#include "file.e"
#include "font.e"
#include "mainloop.e"
#include "mainmenu.e"
#include "msg.e"
#include "raster.e"
#include "setup.e"

static int	curX, curY;
static Window	dialogWindow;

unsigned int CornerLoop (OrigX, OrigY)
   int	* OrigX, * OrigY;
{
   XEvent	input;

   XGrabPointer (mainDisplay, rootWindow, False, ButtonPressMask,
         GrabModeAsync, GrabModeAsync, None, cornerCursor, CurrentTime);

   for (;;)
   {
      XNextEvent (mainDisplay, &input);

      if (input.type == Expose || input.type == VisibilityNotify)
         ExposeEventHandler (&input, TRUE);
      else if (input.type == ButtonPress)
      {
         XUngrabPointer (mainDisplay, CurrentTime);
         *OrigX = input.xbutton.x;
         *OrigY = input.xbutton.y;
         return (input.xbutton.button);
      }
   }
}

static XComposeStatus	c_stat;

int Dialog (Message, Comment, ReturnStr)
   char	* Message, * Comment, * ReturnStr;
   /* returns INVALID if <ESC> is types */
   /* returns FALSE otherwise */
{
   int		i, w, h, str_w, left, top, fore_draw_pixel, fore_erase_pixel;
   int		win_x, win_y, usr_str_w=0, comment_left=0;
   int		dialoging=TRUE, index=0, dsp_w, dsp_h, exposed=FALSE;
   int		rc=FALSE;
   char		buf[80];
   XEvent	input, ev;
   XKeyEvent	* key_ev;
   KeySym	key_sym;
   XWMHints	wmhints;
   XSizeHints	sizehints;
   XSetWindowAttributes	win_attrs;

   str_w = defaultFontWidth * strlen (Message);
   if (*Comment == '\0')
   {
      h = 7 * defaultFontHeight;
      w = max(str_w+6*defaultFontWidth,600);
   }
   else
   {
      int	comment_w = defaultFontWidth * strlen (Comment);

      h = 8 * defaultFontHeight;
      w = max(max(str_w,comment_w)+6*defaultFontWidth,600);
      comment_left = (w - comment_w) / 2;
   }
   left = (w - str_w) / 2;
   top = 2 * defaultFontHeight;

   fore_draw_pixel = myFgPixel;
   fore_erase_pixel = myBgPixel;

   dsp_w = DisplayWidth (mainDisplay, mainScreen);
   dsp_h = DisplayHeight (mainDisplay, mainScreen);

   win_x = (w > dsp_w) ? 0 : (dsp_w - w)/2;
   win_y = (h > dsp_h) ? 0 : (dsp_h - h)/3;

   if (w > dsp_w-2*(brdrW+1)) w = dsp_w-2*(brdrW+1);

   if ((dialogWindow = XCreateSimpleWindow (mainDisplay, rootWindow, win_x,
         win_y, w, h, brdrW, myBorderPixel, myBgPixel)) == 0)
   {
      fprintf (stderr, "Could not create dialog window!\n");
      if (fileModified) EmergencySave ();
      exit (-1);
   }

   win_attrs.save_under = True;
   XChangeWindowAttributes (mainDisplay, dialogWindow, CWSaveUnder, &win_attrs);

   wmhints.flags = InputHint | StateHint;
   wmhints.input = True;
   wmhints.initial_state = NormalState;
   XSetWMHints (mainDisplay, dialogWindow, &wmhints);

   sizehints.flags = PPosition | PSize | USPosition | PMinSize | PMaxSize;
   sizehints.x = win_x;
   sizehints.y = win_y;
   sizehints.width = sizehints.min_width = sizehints.max_width = w;
   sizehints.height = sizehints.min_height = sizehints.max_height = h;
#ifdef NOTR4MODE
   XSetNormalHints (mainDisplay, dialogWindow, &sizehints);
#else
   XSetWMNormalHints (mainDisplay, dialogWindow, &sizehints);
#endif

   XSetTransientForHint (mainDisplay, dialogWindow, mainWindow);
#ifdef MAPBEFORESELECT
   XMapWindow (mainDisplay, dialogWindow);
   XSelectInput (mainDisplay, dialogWindow,
         KeyPressMask | ExposureMask | StructureNotifyMask);
#else
   XSelectInput (mainDisplay, dialogWindow,
         KeyPressMask | ExposureMask | StructureNotifyMask);
   XMapWindow (mainDisplay, dialogWindow);
#endif
   if (warpToWinCenter)
      XWarpPointer (mainDisplay, None, dialogWindow, 0, 0, 0, 0,
            (int)(w/2), (int)(h/2));

   XSync (mainDisplay, False);

   curX = 200;
   curY = (*Comment=='\0') ? 4*defaultFontHeight : 5*defaultFontHeight;

   while (dialoging)
   {
      XNextEvent (mainDisplay, &input);

      if ((input.type==MapNotify && input.xany.window==dialogWindow) ||
            (input.type==Expose && input.xany.window==dialogWindow) ||
            (!exposed &&
            (XCheckWindowEvent (mainDisplay,dialogWindow,ExposureMask,&ev) ||
            XCheckWindowEvent (mainDisplay,dialogWindow,StructureNotifyMask,
            &ev))))
      {
         while (XCheckWindowEvent (mainDisplay,dialogWindow,ExposureMask,&ev)) ;
         while (XCheckWindowEvent (mainDisplay,dialogWindow,StructureNotifyMask,
               &ev)) ;

         XDrawRectangle (mainDisplay, dialogWindow, defaultGC, 0, 0, w-1, h-1);
         MyBox (dialogWindow, defaultGC, 10, 10, w-9, h-9);
         MyBox (dialogWindow, defaultGC, 11, 11, w-10, h-10);
         MyBox (dialogWindow, defaultGC, 12, 12, w-11, h-11);
         XDrawString (mainDisplay, dialogWindow, defaultGC, left, top, Message,
               strlen(Message));
         if (*Comment != '\0')
            XDrawString (mainDisplay, dialogWindow, defaultGC, comment_left,
                  top+defaultFontHeight, Comment, strlen(Comment));
         if (index != 0)
            XDrawString (mainDisplay, dialogWindow, defaultGC,
                  (int)((w-usr_str_w)/2), curY+defaultFontAsc, ReturnStr,
                  index);

         PutCursor (dialogWindow, (int)((w-usr_str_w)/2)+usr_str_w+1, curY,
               fore_draw_pixel);

         exposed = TRUE;
         XSync (mainDisplay, False);

         if ((input.type==MapNotify && input.xany.window==dialogWindow) ||
               (input.type==Expose && input.xany.window==dialogWindow))
            continue;
      }

      if (input.type == VisibilityNotify &&
            input.xany.window==mainWindow &&
            input.xvisibility.state==VisibilityUnobscured)
      {
         while (XCheckWindowEvent (mainDisplay, mainWindow,
               VisibilityChangeMask, &ev)) ;
         if (pinnedMainMenu) XMapRaised (mainDisplay, mainMenuWindow);
         for (i = 0; i < numExtraWins; i++)
            if (extraWinInfo[i].mapped && extraWinInfo[i].raise &&
                  extraWinInfo[i].window != None)
               XMapRaised (mainDisplay, extraWinInfo[i].window);
         XMapRaised (mainDisplay, dialogWindow);
      }
      else if (input.type == KeyPress)
      {
         /* erase the old cursor */
         if (exposed)
            PutCursor (dialogWindow, (int)((w-usr_str_w)/2)+usr_str_w+1, curY,
                  fore_erase_pixel);

         key_ev = &(input.xkey);
         XLookupString (key_ev, buf, 80-1, &key_sym, &c_stat);
         TranslateKeys (buf, &key_sym);
         if ((buf[0]=='\033' && (key_sym & 0xff)=='\033') ||
               (buf[0]=='\r' && (key_sym & 0xff)=='\r') ||
               (buf[0]=='\n' && (key_sym & 0xff)=='\n') ||
               (buf[0]=='\b' && (key_sym & 0xff)=='\b') ||
               (buf[0]=='\b' && (key_sym & 0xff)=='h' &&
               (key_ev->state & ControlMask)) ||
               (buf[0]=='\177' && (key_sym & 0x7f)=='\177') ||
               (key_sym>='\040' && key_sym<='\177'))
         {
            switch (buf[0])
            {
               case '\033':
                  ReturnStr[0] = '\0';
                  dialoging = FALSE;
                  rc = INVALID;
                  break;
               case '\r':
               case '\n':
                  ReturnStr[index] = '\0';
                  dialoging = FALSE;
                  break;
               case '\177': /* <DEL> */
               case '\b': /* <BS> */
                  if (index != 0)
                  {
                     if (exposed)
                        XClearArea (mainDisplay, dialogWindow,
                              (int)((w-usr_str_w)/2), curY, usr_str_w+1,
                              defaultFontHeight+1, FALSE);
                     index--;
                     curX -= defaultFontWidth;
                     usr_str_w -= defaultFontWidth;
                     if (index != 0 && exposed)
                        XDrawString (mainDisplay, dialogWindow, defaultGC,
                              (int)((w-usr_str_w)/2), curY+defaultFontAsc,
                              ReturnStr, index);
                  }
                  break;
               default:
                  if (buf[0] >= '\040' && index < 80)
                  {
                     if (exposed)
                        XClearArea (mainDisplay, dialogWindow,
                              (int)((w-usr_str_w)/2), curY, usr_str_w+1,
                              defaultFontHeight+1, FALSE);
                     curX += defaultFontWidth;
                     usr_str_w += defaultFontWidth;
                     ReturnStr[index++] = buf[0];
                     if (exposed)
                        XDrawString (mainDisplay, dialogWindow, defaultGC,
                              (int)((w-usr_str_w)/2), curY+defaultFontAsc,
                              ReturnStr, index);
                  }
                  break;
            }
         }
         if (exposed)
            PutCursor (dialogWindow, (int)((w-usr_str_w)/2)+usr_str_w+1, curY,
                  fore_draw_pixel);
      }
      else if (input.type == Expose && input.xany.window != dialogWindow)
         ExposeEventHandler (&input, FALSE);
   }

   XDestroyWindow (mainDisplay, dialogWindow);
   if (warpToWinCenter)
      XWarpPointer (mainDisplay, None, drawWindow, 0, 0, 0, 0,
            (int)(ZOOMED_SIZE(drawWinW)>>1), (int)(ZOOMED_SIZE(drawWinH)>>1));
   return (rc);
}
